#ifndef __jabber_sdk_wrap_impl_h__
#define __jabber_sdk_wrap_impl_h__

#include "gen_files\jabber_meeting_csdk.h"
#include "jabber_sdk_wrap.h"
#include "gen_files\meeting_sdk_impl.h"

#include "jcfcoreutils/SystemUtils.h"
#include "csfunified/framework/ServiceFactory.h"
#include "csfunified/framework/UnifiedFactory.h"

using namespace CSFUnified;
using namespace JCFCoreUtils;

typedef JMResult (*PFEventCallbackSet)(JMHandle handle, const char *pEventName, void *pfFuncCallBack);
typedef JMResult (*PFFunctionGet)(const char *pFunctionName, void **pfFunc);

class NetUtilTransport;

namespace JM_SDK_WRAP
{
	class JabberSDKWrapImpl : public IJabberSDKWrap
	{
	public:
		static JabberSDKWrapImpl* getInstance();

	private:
		JabberSDKWrapImpl();
		static JabberSDKWrapImpl* m_pInstance;

	public:

		bool IsSDKLoadSuccessful()
		{
			return m_bIsSDKLoadSuccessful;
		}

		std::string getSDKFolder();

		virtual IDSMgr* getIDSMgr()
		{
			return &m_IDSMgrImpl;
		}

		virtual void setIDSMgrEvent(IDSMgrEvent * pEvent)
		{
			m_IDSMgrEventWrapper.SetHandler(pEvent);
		}

		virtual void setMeetingAccountDelegate(IMeetingAccountInfoDelegate* pMeetingAccountInfoDelegate)
		{
			m_IMeetingAccountInfoDelegateWrapper.SetHandler(pMeetingAccountInfoDelegate);
		}

		virtual IMeetingAccountInfoCallback* getMeetingAccountCallback()
		{
			return &m_IMeetingAccountInfoCallbackImpl;
		}

		virtual void setIMMgrDelegate(IJMIMDelegete* pIMDelegate)
		{
			m_IJMIMDelegeteWrapper.SetHandler(pIMDelegate);
		}

		virtual IJMIMCallback * getIMCallback()
		{
			return &m_IJMIMCallbackImpl;
		}

		virtual void setCommonDependenceDelegate(ICommonDependenciesDelegate *pCommonDependenciesDelegate)
		{
			m_ICommonDependenciesDelegateWrapper.SetHandler(pCommonDependenciesDelegate);
		}

		virtual IJMCommonEventCallback * getCommonEventCallback()
		{
			return &m_IJMCommonEventCallbackImpl;
		}

		virtual void setJMLogger(JMLogger* logger)
		{
			m_JMLoggerWrapper.SetHandler(logger);
		}

		virtual void setTraceLocation(const WCHAR* location);

		virtual void setJMProxy(JMProxy* proxy)
		{
			m_JMProxyWrapper.SetHandler(proxy);
		}

		virtual void setNetworkTransport(INetworkTransport* transport)
		{
			m_INetworkTransportWrapper.SetHandler(transport);
		}

		virtual JMMeetingMgr* getJMMeetingMgr()
		{
			return &m_JMMeetingMgrImpl;
		}

		void setJMMeetingMgrHandler(JMMeetingMgrHandler * lgh)
		{
			m_JMMeetingMgrHandlerWrapper.SetHandler(lgh);
		}

		virtual IWbxMeetingAccountMgr * getIWbxMeetingAccountMgr()
		{
			return &m_IWbxMeetingAccountMgrImpl;
		}

		void setIWbxMeetingAccountObserve(IWbxMeetingAccountObserve * lgh)
		{
			m_IWbxMeetingAccountObserveWrapper.SetHandler(lgh);
		}

		virtual IInstantMeetingMgr* getIInstantMeetingMgr()
		{
			return &m_IInstantMeetingMgrImpl;
		}

		virtual void setIInstantMeetingEvent(IInstantMeetingEvent * lgh)
		{
			m_IInstantMeetingEventWrapper.SetHandler(lgh);
		}

		void setUnifiedFactory(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory)
		{
			m_unifiedFactory = unifiedFactory;
		}

		virtual void startMeetingSDK();

		virtual void stopMeetingSDK();

        virtual void networkChanged(bool bConnected);
        
    private:
        bool loadSDKModule();
        void freeSDKModule();

    private:
        
        HMODULE mLibHandle;
		bool m_bIsSDKLoadSuccessful;
        
        IJMIMCallbackImpl m_IJMIMCallbackImpl;
        IJMCommonEventCallbackImpl m_IJMCommonEventCallbackImpl;
		JMMeetingMgrImpl m_JMMeetingMgrImpl;
		IWbxMeetingAccountMgrImpl m_IWbxMeetingAccountMgrImpl;
		IMeetingAccountInfoCallbackImpl m_IMeetingAccountInfoCallbackImpl;
		IInstantMeetingMgrImpl m_IInstantMeetingMgrImpl;
		IDSMgrImpl m_IDSMgrImpl;

		IJMIMDelegeteWrapper m_IJMIMDelegeteWrapper;
		ICommonDependenciesDelegateWrapper m_ICommonDependenciesDelegateWrapper;
		JMLoggerWrapper m_JMLoggerWrapper;
		JMProxyWrapper m_JMProxyWrapper;
		INetworkTransportWrapper m_INetworkTransportWrapper;
		JMMeetingMgrHandlerWrapper m_JMMeetingMgrHandlerWrapper;
		IWbxMeetingAccountObserveWrapper m_IWbxMeetingAccountObserveWrapper;
		IMeetingAccountInfoDelegateWrapper m_IMeetingAccountInfoDelegateWrapper;
		IInstantMeetingEventWrapper m_IInstantMeetingEventWrapper;
		IDSMgrEventWrapper m_IDSMgrEventWrapper;

		SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
		SMART_PTR_NS::shared_ptr<NetUtilTransport> m_MeetingNetUtilTransport;
    };
}


#endif//__jabber_sdk_wrap_impl_h__
